/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
$(function() {
    var listQuestion = $("#listQuestion");
    var controlHidden = $('.controlClone');
    var form = $('form');
    var FAQ = function() {
        var addQA = function(input) {
            var number = +input.val();
            if (number > 0 && number <= 50) {
                for (var i = 0; i < number; i++) {
                    var append = controlHidden.find('#qa').clone().removeAttr('id');
                    listQuestion.append(append);
                    append.slideDown(1000);
                }
            } else {
                base.notification('error', base.getMessage('errorNumberAddMore'));
            }
        };

        var removeQA = function(obj) {
            bootbox.confirm(base.getMessage('confirmDelete'), function(result) {
                if (result) {
                    obj.remove();
                }
            });
        };
        
        var createFAQ = function() {
            var number = listQuestion.find('.qaItem').size();
            console.log(number);
            form.find('#number_qa').val(number);
            form.submit();
        };

        return {
            addQA: addQA,
            removeQA: removeQA,
            createFAQ: createFAQ
        };
    }();

    $('#addMore').on('click', 'button', function() {
        var input = $(this).prev('input[type=text]');
        FAQ.addQA(input);
    });

    listQuestion.on('click', '.btnRemoveQA', function() {
        var item = $(this).closest('.qaItem');
        FAQ.removeQA(item);
    });

    $('.btnSave').on('click', function(e) {
        e.preventDefault();
        FAQ.createFAQ();
    });
    listQuestion.sortable();
});